<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
  <html>
  <head>
  <style>
	body, td, th {
		font-family: Trebuchet MS,Arial,sans-serif,Tahoma;
		font-size: 13px;
		color: #222; 
	}
	
	table {
		border-collapse: collapse;
	}
	
	th {
		font-size: 14px;
		font-weight: bold;
		background-color: #CCCCCC;
	}
	
	td, th {
		padding: 2px;
		border: 1px solid black;
		text-align: left;
	}
	
	td:nth-child(1), td:nth-child(3), th:nth-child(1), th:nth-child(3) {
		border-right-width: 3px;
	}
	
	tr:nth-child(2n) {
		background-color: #F0F0F0;
	}
	
	.header {
		clear: both;
		overflow: auto;
		margin-bottom: 20px;
	}
	
	.header > * {
		clear: both;
	}
	
	.header > * > * {
		float: left;
		width: 200px;
	}
	
	.header > * > *:last-child {
		width: 300px;
		font-weight: bold;
	}
	
	</style>
  </head>
  <body>
  <h2>Parameters</h2>
	<div class='header'>
		<div><div>Datum gegenereerd:</div><div><xsl:value-of select="Parameters/KL/_00/_01/Left/Value"/>-<xsl:value-of select="Parameters/KL/_00/_01/Right/Value"/>&#160;<xsl:value-of select="Parameters/KL/_00/_00/Left/Value"/>:<xsl:value-of select="Parameters/KL/_00/_00/Right/Value"/></div></div>
		<div><div>Projectnaam:</div><div><xsl:value-of select="Parameters/System/ProjectName/Value"/></div></div>
		<div><div>Adres:</div><div><xsl:value-of select="Parameters/System/ProjectAddress/Value"/></div></div>
		<div><div>Stad:</div><div><xsl:value-of select="Parameters/System/ProjectCity/Value"/></div></div>
		<div><div>Onderstation:</div><div><xsl:value-of select="Parameters/SE/_00/_01/Right/Value"/></div></div>
	</div>
    <table>
	  <thead>
		  <tr>
			<th>Functie</th>
			<th>Omschrijving links</th>
			<th>Waarde links</th>
			<th>Omschrijving rechts</th>
			<th>Waarde rechts</th>
		  </tr>
	  </thead>
	  <tbody>
		 <xsl:for-each select="Parameters/*[self::AI or self::AO or self::DI or self::DO or self::PI or self::AL or self::AT or self::BO or self::EG or self::KE or self::KL or self::KR or self::LU or self::PI or self::RD or self::RP or self::SE or self::SK]/*/*">
		  <tr>
			<td><xsl:value-of select="translate(local-name(../..), '_', '')"/>.<xsl:value-of select="translate(local-name(..), '_', '')"/>.<xsl:value-of select="translate(local-name(.), '_', '')"/></td>
			<td><xsl:value-of select="Left/Description"/></td>
			<td><xsl:value-of select="Left/Value"/></td>
			<td><xsl:value-of select="Right/Description"/></td>
			<td><xsl:value-of select="Right/Value"/></td>
		  </tr>
		  </xsl:for-each>
		</tbody>
    </table>
  </body>
  </html>
</xsl:template>
</xsl:stylesheet>